﻿IF EXISTS (SELECT 1 FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[VX_TR_StratumModifLog_Delete]'))
	DROP TRIGGER [dbo].[VX_TR_StratumModifLog_Delete]
GO

CREATE TRIGGER [dbo].[VX_TR_StratumModifLog_Delete]
	ON [dbo].[Stratum]
	AFTER DELETE
AS
BEGIN
	SET NOCOUNT ON;
	INSERT INTO [dbo].[StratumModifLog] (
		[Respondent],
		[QuotaId],
		[OldStratum],
		[Stratum],
		[OldIncrementValue],
		[IncrementValue],
		[AppName],
		[DateTime]
	)
	SELECT
		deleted.[StrRespondent],
		deleted.[StrQuotaId],
		deleted.[StrStratum],
		NULL,
		deleted.[IncrementValue],
		NULL,
		APP_NAME(),
		GETUTCDATE()
	FROM deleted;
END
GO
